IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Grupo_Familiar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Grupo_Familiar
END
GO

CREATE  FUNCTION [dbo].[CF_Grupo_Familiar] (@Id_Cliente_Temp INT)
RETURNS VARCHAR (1000)
AS
BEGIN 

DECLARE @Legajo				VARCHAR(30)
DECLARE @Razon_Social		VARCHAR(1000)
DECLARE @Razon_Sociales		VARCHAR(1000)

--Titular
SELECT @Razon_Social= C.Razon_Social, @Legajo = CONVERT(VARCHAR(30),C.Legajo )
FROM Clientes_Temp C
WHERE C.Id_Cliente_Temp = ISNULL(@Id_Cliente_Temp,0)

IF @Legajo is null	  RETURN @Razon_Social



DECLARE curNombre CURSOR FOR

	SELECT ISNULL(LTRIM(RTRIM(C.Razon_Social)), '') AS Razon_Social
	FROM Clientes_Temp C
	WHERE C.Legajo =  CONVERT(VARCHAR(30),ISNULL(@Id_Cliente_Temp,0),0)
		 
	SET @Razon_Sociales = @Razon_Social

OPEN curNombre
FETCH NEXT FROM curNombre INTO @Razon_Social
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @Razon_Sociales = @Razon_Sociales + ' / ' + @Razon_Social
	FETCH NEXT FROM curNombre INTO @Razon_Social
END
CLOSE curNombre
DEALLOCATE curNombre

RETURN @Razon_Sociales
END

